class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Calgary Sun'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    remove_tags_before = dict(id='')
    remove_tags = [dict(name='div', attrs={'class':['breadCrumb','articleControls thin','leftBox','bottomBox clear']}),
                   dict(name='div', attrs={'id':['header_v2','footer','date','topBar','mainNav','channelBoxes','sixPack','rightColumn','buttonRow','textAds','commentsBottom','sixNews','video']}),
                   dict(name='ul', attrs={'class':['clearIt','tabs dl contentSwap']}),
                   dict(name='p', attrs={'class':['byline','updated']}),
                   dict(name='img'),]

    feeds          = [(u'World News', u'http://www.calgarysun.com/news/world/rss.xml'), 
                                 (u'Calgary and Alberta',u'http://www.calgarysun.com/news/alberta/rss.xml'),
                                 (u'Columnists',u'http://www.calgarysun.com/news/columnists/rss.xml'),
                                 (u'Comment',u'http://www.calgarysun.com/comment/rss.xml'),
                                 (u'Sports',u'http://www.calgarysun.com/sports/rss.xml'),
                                 (u'Gadgets',u'http://www.calgarysun.com/life/gadgets/rss.xml'),
                                 (u'Health',u'http://www.calgarysun.com/life/healthandfitness/rss.xml'),
                                 (u'Movies',u'http://www.calgarysun.com/entertainment/movies/rss.xml'),
                                 (u'Music',u'http://www.calgarysun.com/entertainment/music/rss.xml'),
                                 (u'Tech',u'http://www.calgarysun.com/tech/rss.xml'),
                          ]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
